import pandas as pd
from collections import Counter
from matplotlib import pyplot as plt
import numpy as np
import csv

data = pd.read_csv('data.csv')
ids = data['Responder_id']
responses = data['LanguagesWorkedWith']

language_cnt = Counter()
for response in responses:
    language_cnt.update(response.split(";"))
    
languages = []
popularity = []
# 15 is too much for pie charts. 5 is more than enough
# 15 is good for bar charts
#for x in language_cnt.most_common(15):
for x in language_cnt.most_common(5):
    languages.append(x[0])
    popularity.append(x[1])
    
plt.figure(1)

plt.pie(popularity, labels=languages)

plt.title("Language popularity")
plt.tight_layout()
plt.savefig("pandas_pie_chart.png")
plt.show()